﻿//////////////////////////////////////////////
// BmpFileHeader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::bmp
{
	class BmpFileHeader final
	{
		public :

			// Constants
			inline static unsigned int BYTE_SIZE = 14 ;

		public :

			// Functions
			// Encode
			void encodeInData (nkMemory::BufferView<unsigned char> data) ;
			// Decode
			void decodeFromData (nkMemory::BufferView<unsigned char> data) ;

		public :

			// Attributes
			// 2 bytes for header 'B' and 'M'
			unsigned char _headChars [2] ;
			// 4 bytes for size of file
			unsigned int _fileByteSize ;

			// 4 bytes reserved for app exporting
			unsigned char _reserved [4] ;

			// 4 bytes for the offset where to find the data inside
			unsigned int _dataByteOffset ;
	} ;
}